library(MSBVAR)
library(MCMCpack)

basefn<-"cluster400" #base file name
nloop<-1000 # number of loops
alpha<-1 # value of alpha (lambda as in the article) in DP

#the number of DPV clusters; DPV: dependent variables
# M is determined based on DIC using program DetermineMDIC.R
M<-3 
k<-10 #the number of DPVs 

dzeta<-function(par1,par2,par3){ #return in log scale
# par1: zeta, par2: sum of log Pi, par3: length of Pi
  if(par1>1) tmp<-2*log(par1)
    else tmp<-0
  lgamma(par3*par1)+{par1-1}*par2-lgamma(par1)*par3-tmp
  }
list.fun<-function(vec){
  uniq.len<-length(unique(vec))
  tmp.rle<-order(table(vec),decreasing=TRUE)
  ret<-as.list(1:uniq.len)
  for(i in 1:uniq.len){
    val<-tmp.rle[i]
    ret[[i]]<-list(lab=val,subj=which(vec==val))
    }
  return(ret)
  }
tob<-function(num){
  ret<-numeric()
  i<-1
  while(num>0){
    if(num%%2==1) ret<-c(ret,i)
    num<-floor(num/2)
    i<-i+1
  }
  ret
  }

distance<-function(p,ptn,dpc){
  dep.pat<-p[1:(M-1),ptn]
  dep.pat<-c(dep.pat,2^k-1-sum(dep.pat))
  res<-matrix(0,nrow=n*(n+1)/2,ncol=k)
  for(m in 1:M){
    dep.clu<-tob(dep.pat[m])
    c.m<-dpc[(m-1)*n+1:n,ptn]
    tmp<-matrix(0,n,n)
    for(j in 1:max(c.m)){
      i.clu<-which(c.m==j)
      tmp[i.clu,i.clu]<-1
      }
    res[,dep.clu]<-vech(tmp)
    }
  return(res)
  }
  
big<-function(data.idx){
set.seed(2013*data.idx)

iteration<-function(draw=F,prev){
  Pi<-prev$Pi
  dk<-prev$dk
  pos<-prev$pos
  pat<-prev$pat
  pat.count<-prev$pat.count
  bhat<-prev$bhat
  idx.bm<-prev$idx.bm
  index<-prev$index
  Sigma<-prev$Sigma
  Sigma0<-prev$Sigma0
  sigma<-prev$sigma
  zeta<-prev$zeta
  dp.c<-prev$dp.c
  bmi<-prev$bmi
       
  # the binary rep of current clustering
  bin<-apply(dk*2^(t(bin.pos*t(dk))),1,sum)

  dk<-dk[order(bin),]

  tmp<-sort(bin)[-M]
  newpat<-TRUE
  if(pat.count>0){
    if(all(pat[1:(M-1),pos]==tmp)) newpat<-F
    else{
      for(i in 1:pat.count){
        if(all(pat[1:(M-1),i]==tmp)){
          newpat<-F
          pos<-i
          break;
          }
        }
      }
    }
  if(newpat){
    pat.count<-pat.count+1
    if(draw){
      idx.bm<-c(idx.bm,pat.count)
      pat<-cbind(pat,c(tmp,1,index))
      }
    else{
      pat<-cbind(pat,c(tmp,0,pat.count))
      bmi.last.pat<-pat.count
      }
    c.cur<-matrix(rep(rep(1:2,each=n/2),M),ncol=M)#matrix(1,nrow=n,ncol=M)#
    i.clu<-1:(M+1)#1+10*0:M#
    }
  else{
    bmi.last.pat<-pat[M+1,pos]
    if(draw){
      pat[M,pos]<-pat[M,pos]+1
      pat[M+1,pos]<-index
      idx.bm<-c(idx.bm,pos)
      }
    c.cur<-matrix(dp.c[,pos],ncol=M)
    bmi.cur<-bmi[[bmi.last.pat]]$b
    i.clu<-bmi[[bmi.last.pat]]$clu
    }
  
  bmi.new<-numeric() #updated beta_{m,i} in current loop
  i.clu.new<-1:(M+1)
 
  betaTmp1<-NULL
  xbeta<-matrix(NA,nrow=n,ncol=M)

  for(m in 1:M){ # there are M clusters
    # responses are in the current cluster
    clu<-which(dk[m,]==1)
    kM<-length(clu)

    # take the sub-matrix from Sigma
    Sigma.m<-Sigma[clu,clu]
    iSigma.m<-solve(Sigma.m)
    iV<-1/c(rep(sigma.b,fixed),rep(sigma,nknot))
    
    tmp2<-matrix(0,nrow=b.len,ncol=b.len)
    tmp3<-matrix(0,nrow=b.len,ncol=1)
    for(j in 1:n){
      xx.t<-matrix(rep(xx[j,],kM),nrow=kM,byrow=TRUE)
      y.t<-y[j,clu]
      tmp<-t(xx.t)%*%iSigma.m
      tmp2<-tmp2+tmp%*%xx.t
      tmp3<-tmp3+tmp%*%y.t
      }
    tmp<-solve(tmp2+diag(iV))
    bhat[m,]<-rmultnorm(1,tmp%*%tmp3,tmp)
    sigma<-1/rgamma(1,a+nknot/2,scale=c+sum(bhat[m,-(1:fixed)]^2)/2)
    
    # DP to cluster subjects
    if(newpat) bmi.cur.m<-matrix(rep(bhat[m,],each=2),ncol=b.len)#matrix(bhat[m,],ncol=b.len)#matrix(0,nrow=1,ncol=b.len)#rmultnorm(20,bhat[m,],diag(Sigma0[m,]))#
    else bmi.cur.m<-matrix(bmi.cur[i.clu[m]:(i.clu[m+1]-1),],ncol=b.len)
    
    # draw Sigma for y based on the subject cluster assignment
    y.t<-matrix(y[,clu],nrow=n,ncol=kM)
    xbmj<-rep(0,n)
    c.uniq<-sort(unique(c.cur[,m]))
    c.uniq.len<-length(c.uniq)
    
    for(i in 1:c.uniq.len){
      iclu<-which(c.cur[,m]==c.uniq[i])
      xbmj[iclu]<-xx[iclu,]%*%bmi.cur.m[i,]
      }
    cy.t<-y.t-matrix(rep(xbmj,kM),nrow=n)
    Sigma.m<-riwish(n+nu, t(cy.t)%*%cy.t+S[clu,clu])
    iSigma.m<-solve(Sigma.m)
   
    #the subject assignment before DP
    prev.c<-list.fun(c.cur[,m])
    prev.uniq.len<-length(prev.c)
    
    for(i in 1:n){
      c.i<-c.cur[i,m]
      c.rle<-rle(sort(c.cur[-i,m]))
      c.uniq.len<-length(c.rle$values)
      last<-c.uniq.len+1
      prob<-1:last
      xx.t<-matrix(rep(xx[i,],kM),nrow=kM,byrow=TRUE)
      Sigma.bmi<-solve(t(xx.t)%*%iSigma.m%*%xx.t+diag(1/Sigma0[m,]))
      ypsig<-y.t[i,]%*%iSigma.m
      for(j in 1:c.uniq.len){
        xbj<-xx.t%*%bmi.cur.m[j,]
        prob[j]<-log(c.rle$lengths[j])+ypsig%*%xbj-t(xbj)%*%iSigma.m%*%xbj/2 #The log prob in DP
        }
      tmp<-ypsig%*%xx.t #ypsig*x_i
      
      prob[last]<-log(alpha[m])+{log(det(Sigma.bmi))+tmp%*%Sigma.bmi%*%t(tmp)-sum(log(Sigma0[m,]))}/2
      prob<-exp(prob-max(prob))
      newc<-which(rmultinom(1,1,prob)==1)
      
      del<-which(c.i==sort(unique(c.cur[,m])))
      change<-F
      if(newc==last){
        change<-TRUE
        if(is.element(c.i,c.rle$values)){
          c.cur[i,m]<-c.rle$values[c.uniq.len]+1
          bmi.cur.m<-rbind(bmi.cur.m,rmultnorm(1,Sigma.bmi%*%t(tmp),Sigma.bmi))
          }
        else bmi.cur.m[del,]<-rmultnorm(1,Sigma.bmi%*%t(tmp),Sigma.bmi)
        }
      else{
        c.cur[i,m]<-c.rle$values[newc]
        if(!is.element(c.i,c.rle$values)) bmi.cur.m<-matrix(bmi.cur.m[-del,],ncol=b.len)
        }
      if(c.i!=c.cur[i,m]|change){
        tmp<-which(c.cur[i,m]==sort(unique(c.cur[,m])))
        xbmj[i]<-xx[i,]%*%bmi.cur.m[tmp,]
        cy.t[i,]<-y.t[i,]-xbmj[i]
        Sigma.m<-riwish(n+nu, t(cy.t)%*%cy.t+S[clu,clu])
        iSigma.m<-solve(Sigma.m)
        }
      }    
    
    cur.c<-list.fun(c.cur[,m])
    cur.uniq.len<-length(cur.c)
    if(cur.uniq.len>=prev.uniq.len){
      for(i in 1:cur.uniq.len){
        best.lab<-prev.c[[1]]$lab
        best.len<--1
        
        for(j in 1:prev.uniq.len){
          tmp.len<-length(intersect(prev.c[[j]]$subj, cur.c[[i]]$subj))
          if(tmp.len>best.len){
            best.lab<-j
            best.len<-tmp.len
            }
          }
        c.cur[cur.c[[i]]$subj,m]<-prev.c[[best.lab]]$lab
        prev.uniq.len<-prev.uniq.len-1
        if(prev.uniq.len==0) break
        prev.c<-prev.c[-best.lab]
        }
      }
    
    else{
      for(i in 1:prev.uniq.len){
        best.lab<-cur.c[[1]]$lab
        best.len<--1
        
        for(j in 1:cur.uniq.len){
          tmp.len<-length(intersect(prev.c[[i]]$subj, cur.c[[j]]$subj))
          if(tmp.len>best.len){
            best.lab<-j
            best.len<-tmp.len
            }
          }
        
        c.cur[cur.c[[best.lab]]$subj,m]<-prev.c[[i]]$lab
        cur.uniq.len<-cur.uniq.len-1
        if(cur.uniq.len==0) break
        cur.c<-cur.c[-best.lab]
        }
      tmp.list<-sort(unique(c.cur[,m]))
      tmp.len<-length(tmp.list)
      for(i in 1:tmp.len)
        c.cur[which(c.cur[,m]==tmp.list[i]),m]<-i
      }    
    
    c.uniq.len<-length(unique(c.cur[,m]))
    c.uniq<-sort(unique(c.cur[,m]))
    for(i in 1:c.uniq.len){
      iclu<-which(c.cur[,m]==c.uniq[i])

      tmp2<-matrix(0,nrow=b.len,ncol=b.len)
      tmp3<-matrix(0,nrow=b.len,ncol=1)
      for(j in iclu){
        xx.t<-matrix(rep(xx[j,],kM),nrow=kM,byrow=TRUE)
        y.t<-y[j,clu]
        tmp<-t(xx.t)%*%iSigma.m
        tmp2<-tmp2+tmp%*%xx.t
        tmp3<-tmp3+tmp%*%y.t
        }
      tmp<-solve(tmp2+diag(1/Sigma0[m,]))
      bmi.cur.m[i,]<-rmultnorm(1,tmp%*%tmp3,tmp)
      }
      
    bmi.new<-rbind(bmi.new,bmi.cur.m)
    i.clu.new[m+1]<-i.clu.new[m]+c.uniq.len
    
    tmp<-a+c.uniq.len*b.len/2
    for(i in 1:b.len)
      Sigma0[m,i]<-1/rgamma(1,tmp,scale=c+sum((bmi.cur.m[,i])^2)/2)
    
    Sigma[clu,clu]<-Sigma.m

    betaTmp<-matrix(NA,nrow=n,ncol=b.len)
    xbetaTmp<-xbeta
    c.uniq<-sort(unique(c.cur[,m]))
    choosem<-NULL
    for(i in 1:c.uniq.len){
      iclu<-which(c.cur[,m]==c.uniq[i])
	if (i==1)
	{
		len.iclu<-length(iclu)
		choosem<-iclu
	}
	else
	{
		if (length(iclu)>len.iclu) 
		{
			len.iclu<-length(iclu)
			choosem<-iclu
		}
	}

	xbeta[iclu,m]<-xx[iclu,]%*%bmi.cur.m[i,]

    }   
    if (m==1)
    {
    	choose<-choosem
      lenChoose<-length(choosem)
    }
    else
    {
	choose<-c(choose,choosem)
      lenChoose<-c(lenChoose,length(choosem))
    }

    } 

# cluster (subject and variable clusters)
  dk.p<-dk

  pdkTmp<-pdk
  for(i in 1:k){
    Pi[,i]<-rdirichlet(1,rep(zeta,M)+dk[,i])
    locaSum<-0
    for(j in 1:M){
      if (j==1) 
      {
		loca<-choose[1:lenChoose[1]]
		locaSum<-lenChoose[1]
	}
	else
	{
		loca<-choose[(locaSum+1):(locaSum+lenChoose[j])]
		locaSum<-locaSum+lenChoose[j]
	}
      pdk[j]<-log(Pi[j,i])-.5*sum({y[,i]-xbeta[,j]}^2)/Sigma[i,i] #Actually the log pdk
     }  
    pdk<-pdk-max(pdk)
    dk[,i]<-rmultinom(1,1,exp(pdk))
    }

  # Check wellness of clustering
  if(any(apply(dk,1,sum)==0)) 
  {
	dk<-dk.p
 }

  # MH to update zeta with jumping dist lognormal
  sum.log.P<-sum(log(Pi[,k]))
  zeta.l<-log(zeta)
  can<-rlnorm(1,zeta.l,v)
  ratio<-min(exp(dzeta(can,sum.log.P,M)-dzeta(zeta,sum.log.P,M))/ (dlnorm(can,zeta.l,v)/dlnorm(zeta,zeta.l,v)),1)
  if(is.nan(ratio)){
    ratio<-0
    #ratio.nan<-c(ratio.nan,index)
    }
  if(runif(1)<ratio){
    zeta<-can
    }
  
  if(newpat) dp.c<-cbind(dp.c,c(c.cur))
  else dp.c[,pos]<-c(c.cur)
  
  if(draw){
    bmi[[index]]<-list(b=bmi.new,clu=i.clu.new)
    index<-index+1
    }
  else{
    bmi[[bmi.last.pat]]<-list(b=bmi.new,clu=i.clu.new)
    }
  return(list(Pi=Pi, dk=dk, pos=pos, pat=pat, pat.count=pat.count, bhat=bhat, idx.bm=idx.bm, index=index, Sigma=Sigma, Sigma0=Sigma0, dp.c=dp.c, sigma=sigma, zeta=zeta, bmi=bmi, dif=diff(i.clu.new)))
  }

x<-pst[,1,data.idx]
y<-pst[,2:11,data.idx]

#construct the design matrix X
  xx<-matrix(0,nrow=n,ncol=b.len)
  xx[,1:fixed]<-cbind(1,x,x^2)
  for(i in 1:nknot)
    xx[,i+fixed]<-as.numeric(knot[i+1]<x)*(x-knot[i+1])^2

  Pi<-matrix(1,nrow=M,ncol=k)/M
  Sigma0<-matrix(0.5,nrow=M,ncol=b.len) #Covariance matrix for the base dist G0 in DP (diagonal matrix for each dep cluster)
  sigma<-1 # var of coefficients of splines
  dk<-matrix(c(1,1,rep(0,11),1,1,rep(0,10),rep(1,5)),nrow=M,byrow=TRUE)

  bhat<-matrix(rep(0,b.len*M),nrow=M) # each row of bhat corresponds to a cluster
  Sigma<-riwish(nu,S)
  pdk<-rep(1,M) # prob of drawing posterior dk
  zeta<-.75
    
  dp.c<-numeric() #store parameter c in DP
  bmi<-list()
  idx.bm<-numeric()
  index<-1
  pat.count<-0
  pat<-numeric() # pattern vector to store the cluster info for response variables
  pos<-1
  
  tmp.cluster<-list(Pi=Pi, dk=dk, pos=pos, pat=pat, pat.count=pat.count, bhat=bhat, idx.bm=idx.bm, index=index, Sigma=Sigma, Sigma0=Sigma0, dp.c=dp.c, sigma=sigma, zeta=zeta, bmi=bmi)
 
  # burn in
  for(i in 1:b.nloop)
    tmp.cluster<-iteration(draw=F,tmp.cluster)
  
  # calculate the average distance matrix
  dist.ave<-matrix(0,nrow=n*(n+1)/2,ncol=k)
  tmp.cluster$index<-tmp.cluster$pat.count+1
  for(i in 1:B){
    tmp.cluster<-iteration(draw=TRUE,tmp.cluster)
    dist.ave<-dist.ave+distance(tmp.cluster$pat, tmp.cluster$pos, tmp.cluster$dp.c)
    }
  dist.ave<-dist.ave/B

  # draw
  dist.min<-n*(n+1)*k/2
  pat.f.dep<-numeric()
  pat.f.subj<-numeric()
  for(i in 1:d.nloop){
    tmp.cluster<-iteration(draw=TRUE,tmp.cluster)
    dist.euc<-sum((dist.ave-distance(tmp.cluster$pat, tmp.cluster$pos, tmp.cluster$dp.c))^2)
    if(dist.euc<dist.min){
      dist.min<-dist.euc
      pat.f.dep<-tmp.cluster$pos
      pat.f.subj<-tmp.cluster$dp.c[,pat.f.dep]
      }
    else if(dist.euc==dist.min){
      pat.f.dep<-c(pat.f.dep,tmp.cluster$pos)
      pat.f.subj<-cbind(pat.f.subj,tmp.cluster$dp.c[,tmp.cluster$pos])
      }
    }

  if(length(pat.f.subj)>n*M) pat.f.subj<-pat.f.subj[,1]
  
  pat.o<-order(tmp.cluster$pat[M,],decreasing=TRUE)
  max.pat<-min(5,length(pat.o))
  if(length(pat.o)>1) pat.f<-tmp.cluster$pat[,pat.o[1:max.pat]]
  else pat.f<-tmp.cluster$pat

  #calculate accrurate rate
  dep.clu<-c(0,cumsum(dep.clu))
  
  pat.f.subj<-matrix(pat.f.subj,nrow=n)
  pat.f.dep<-pat.f[1:{M-1},1]
  pat.f.dep<-c(pat.f.dep,2^k-1-sum(pat.f.dep))
  right<-0
  Mode<-matrix(0,nrow=M,ncol=2)
  tmpp<-rep(0,M)
  for(y.clu in 1:M){
    Mode[y.clu,1]<-as.numeric(names(sort(-table(pat.f.subj[1:subject[y.clu],y.clu] ))[1]))
    Mode[y.clu,2]<-as.numeric(names(sort(-table(pat.f.subj[{1+subject[y.clu]}:n,y.clu] ))[1]))
    for (y.clu1 in 1:M)
    {
       tmpp[y.clu1]<-length(intersect(tob(pat.f.dep[y.clu]),{dep.clu[y.clu1]+1}:dep.clu[y.clu1+1]))
    } 
    tmp<-max(tmpp)   
  # calcuate the accuracy. This is only for simulated data. 
    right<-right+tmp*(length(which(pat.f.subj[1:subject[y.clu],y.clu]==Mode[y.clu,1]))+length(which(pat.f.subj[{1+subject[y.clu]}:n,y.clu]==Mode[y.clu,2])))
    }
  right<-right/n/k
  
  #calculate the number of joint clusters
  n.clu<-0
  for(j in 1:M)
    n.clu<-n.clu+length(unique(pat.f.subj[,j]))
  
  #calculate Sensitivity and Specificity. This is only for simulated data. 

  conf<-matrix(0,nrow=n,ncol=k)
  for(j in 1:M){
    dpv<-tob(pat.f.dep[j])
    if (length(which(dpv%in%seq(6,8)))>=1)
    {
		seq.no<-3
    		for(i in 1:2){
		subj<-which(pat.f.subj[,j]==Mode[j,i])
	      conf[subj,dpv]<-seq.no
      	seq.no<-seq.no+1
      	}
    }

    if (length(which(dpv%in%c(9,10)))>=1)
    {
		seq.no<-5
    		for(i in 1:2){
		subj<-which(pat.f.subj[,j]==Mode[j,i])
	      conf[subj,dpv]<-seq.no
      	seq.no<-seq.no+1
      	}
    }

    if (length(which(dpv%in%seq(1,5)))>=2)
    {
		seq.no<-1
    		for(i in 1:2){
		subj<-which(pat.f.subj[,j]==Mode[j,i])
	      conf[subj,dpv]<-seq.no
      	seq.no<-seq.no+1
      	}
    }

}
  
  se<-rep(0,6)
  sp<-rep(0,6)

# the sum of the denomiator has to be equal to n*number of dependent variables=400*10=4000 in this 
# example
  se[1]<-sum(as.numeric(conf[1:subject[1],1:5]==1))/1250
  sp[1]<-(sum(as.numeric(conf[,6:10]!=1))+sum(as.numeric(conf[{1+subject[1]}:n,1:5]!=1)))/2750

  cat("conf[1:subject[1],1:5] ",conf[1:subject[1],1:5],"\n")

  se[2]<-sum(as.numeric(conf[{1+subject[1]}:n,1:5]==2))/750
  sp[2]<-(sum(as.numeric(conf[,6:10]!=2))+sum(as.numeric(conf[1:subject[1],1:5]!=2)))/3250

  cat("conf[{1+subject[1]}:n,1:5] ",conf[{1+subject[1]}:n,1:5],"\n")

  se[3]<-sum(as.numeric(conf[1:subject[2],6:8]==3))/600
  sp[3]<-(sum(as.numeric(conf[,c(1:5,9,10)]!=3))+sum(as.numeric(conf[{1+subject[2]}:n,6:8]!=3)))/3400
  
  cat("conf[1:subject[2],6:8] ",conf[1:subject[2],6:8],"\n")

  se[4]<-sum(as.numeric(conf[{1+subject[2]}:n,6:8]==4))/600
  sp[4]<-(sum(as.numeric(conf[,c(1:5,9,10)]!=4))+sum(as.numeric(conf[1:subject[2],6:8]!=4)))/3400

  cat("conf[{1+subject[2]}:n,6:8] ",conf[{1+subject[2]}:n,6:8],"\n")

  se[5]<-sum(as.numeric(conf[1:subject[3],9:10]==5))/360
  sp[5]<-(sum(as.numeric(conf[,1:8]!=5))+sum(as.numeric(conf[{1+subject[3]}:n,9:10]!=5)))/3640
  
  cat("conf[1:subject[3],9:10] ",conf[1:subject[3],9:10],"\n")

  se[6]<-sum(as.numeric(conf[{1+subject[3]}:n,9:10]==6))/440
  sp[6]<-(sum(as.numeric(conf[,1:8]!=6))+sum(as.numeric(conf[1:subject[3],9:10]!=6)))/3560

  cat("conf[{1+subject[3]}:n,9:10] ",conf[{1+subject[3]}:n,9:10],"\n")

  cat(data.idx,"\t",n.clu,"\t",right,"\t",se,"\t",sp,"\n",file=fn,append=TRUE)
  list(n.clu=n.clu,accurate=right,se=se,sp=sp)
  }

  
  
################
# main program #
################
loadfn<-paste(basefn,".Rdata",sep="")
#read data
load(loadfn)
b.nloop<-nloop*.3 # number of burn in iterations
B<-nloop*.3 # number of iterations to get average distance matrix
d.nloop<-nloop-b.nloop-B # # number of draws

#n number of observation read from data set
sub.th<-0.95*n

#write data
fn<-paste(basefn,"_sesp400.txt",sep="")
cat("Simu\tn.clu\tAccu\tSensitivity(6)\t\tSpecificity(6)\n",file=fn,append=F)

# give initial values, M: # of clusters, knot: knots vector(10 knots),
# V: covariance of bhat (iV: its inverse), v: jumping dist for zeta lognormal(zeta.prev,v)
# pattern: the pattern of clustering one dimension with last one be the frequency
bin.pos<-0:(k-1)
nknot<-10 # number of knots
nknot1<-nknot+2
nu<-k+2
a<-c<-0.5 # pars for Inv Gamma dist for sigma
sigma.b<-100 # var of beta_m(fixed)
S<-diag(rep(.5,k))
v<-1.8

knot<-seq(from=rang.x[1],to=rang.x[2],length.out=nknot1)
fixed<-3
b.len<-fixed+nknot
alpha<-rep(alpha,M)
simulation<-100

# Record the starting time
ptm <- proc.time()

parameter.list<-as.list(1:simulation)
parameter.list<-lapply(1:simulation,big)

parameter.list<-as.list(1:10)
parameter.list<-lapply(1:10,big)

n.clu<-numeric()
accurate<-numeric()
se<-sp<-matrix(0,nrow=simulation,ncol=6)
for(i in 1:simulation){
  n.clu<-c(n.clu,parameter.list[[i]]$n.clu)
  accurate<-c(accurate,parameter.list[[i]]$accurate)
  se[i,]<-parameter.list[[i]]$se
  sp[i,]<-parameter.list[[i]]$sp
  }

save(n.clu,accurate,se,sp,file=paste(basefn,"_sesp.Rdata",sep=""))

sfStop()

#end
  