# This program simulate 100 data sets each with three variable clusters and 
# within each variable cluster, there exist two subject clusters that have 
# non-linear patterns.

#n: the number of subject
#beta: coefficients of a covariate of interest
#k is the vector showing the number of variables in each variable cluster
library(MSBVAR)
library(magic)

set.seed(811)
n<-400
rang.x<-c(1,6)
k<-c(5,3,2)#c(5,3)
k.cum<-cumsum(k)
K<-k.cum[length(k)]

# covariance matrix for each variable cluster
Sigma1<-matrix(c(1,-.25,0,0,0,-.25,1,-.5,0,0,0,-.5,1,0,0,0,0,0,1,.3,0,0,0,.3,1),k[1],k[1])
Sigma2<-matrix(c(1,0.1,-.4,0.1,1,-0.1,-0.4,-0.1,1),k[2],k[2])
Sigma3<-matrix(c(0.6,-0.25,-0.25,0.6),k[3],k[3])

# number of Monte Carlo replicates
simulation<-100

pst<-array(0,c(n,K+1,simulation))

for(i in 1:simulation){
  x<-matrix(runif(n,rang.x[1]+.1,rang.x[2]),nrow=n)
  y<-matrix(0,nrow=n,ncol=K)

#nonlinear model
#generate variable cluster 1 that has two subject clusters
  xx<-x[,rep(1,k[1])]
  err<-rmultnorm(n,rep(0,k[1]),Sigma1)
  y[1:250,1:k[1]]<-err[1:250,]+6+5*sin(0.2*pi*(xx[1:250,]-1))
  y[251:n,1:k[1]]<-err[251:n,]-5-5*cos(0.2*pi*(xx[251:n,]-3.5))

#generate variable cluster 2 that has two subject clusters
  xx<-x[,rep(1,k[2])]
  err<-rmultnorm(n,rep(0,k[2]),Sigma2/4)
  y[1:200,1:k[2]+k.cum[1]]<-err[1:200,]+10-0.8*xx[1:200,]
  y[201:n,1:k[2]+k.cum[1]]<-err[201:n,]-5-3*exp(0.4*(xx[201:n,]-1))

#generate variable cluster 3 that has two subject clusters  xx<-x[,rep(1,k[3])]
  err<-rmultnorm(n,rep(0,k[3]),Sigma3)
  y[1:180,1:k[3]+k.cum[2]]<-err[1:180,]+15+4*log(0.4*(xx[1:180,]-0.8))
  y[181:n,1:k[3]+k.cum[2]]<-err[181:n,]-2+0.1*xx[181:n]
  
  pst[,,i]<-cbind(x,y)
  }

dep.clu<-k
subject<-c(250,200,180)#c(250,200)#
M<-length(k)
#output the data into a file
save(n,M,dep.clu,subject,pst,rang.x,file="cluster400.Rdata")

